// Franzis - Programmieren mit KI - Bausatz - Niklas Heinzel - 2025
// 4_Potenziometer-und-Buzzer-Skript

// Definition der Pins
const int potPin = A0;     // Analoger Pin A0 für das Potenziometer
const int buzzerPin = 2;   // Digitaler Pin D2 für den Buzzer

void setup() {
  pinMode(potPin, INPUT);       // Potenziometer als Eingabe konfigurieren
  pinMode(buzzerPin, OUTPUT);   // Buzzer als Ausgang konfigurieren
  Serial.begin(9600);           // Serielle Kommunikation starten
}

void loop() {
  // Lies den Wert des Potenziometers (0–1023)
  int potValue = analogRead(potPin);

  // Schreibe den Potenziometerwert auf den seriellen Monitor
  Serial.print("Potenziometer-Wert: ");
  Serial.println(potValue);

  // Skaliere den Poti-Wert auf eine Frequenz für den Ton (100 Hz bis 1000 Hz)
  int frequency = map(potValue, 0, 1023, 100, 1000);

  // Spiele die Tonfolge mit der berechneten Frequenz
  playToneSequence(frequency);

  // Kurze Pause, um die Ausführung etwas zu verlangsamen
  delay(500);
}

// Funktion, um eine Tonfolge basierend auf der Frequenz zu spielen
void playToneSequence(int baseFrequency) {
  // Spiele drei aufeinanderfolgende Töne mit verschiedenen Frequenzen
  tone(buzzerPin, baseFrequency, 200);        // Grundton
  delay(200);                                // Warte kurz
  tone(buzzerPin, baseFrequency + 100, 200); // Erhöhte Frequenz
  delay(200);                                // Warte kurz
  tone(buzzerPin, baseFrequency - 100, 200); // Verringerte Frequenz
  delay(200);                                // Warte kurz
}
